<?php
require_once 'config.php';

$method = $_SERVER['REQUEST_METHOD'];
$action = $_GET['action'] ?? '';

switch ($action) {
    case 'history':
        getHistory();
        break;
    case 'favorites':
        if ($method === 'GET') {
            getFavorites();
        } elseif ($method === 'POST') {
            toggleFavorite();
        }
        break;
    case 'check-favorite':
        checkFavorite($_GET['video_id'] ?? 0);
        break;
    default:
        echo json_encode(['error' => 'Invalid action']);
}

function getHistory() {
    if (!isset($_SESSION['user_id'])) {
        echo json_encode(['error' => 'Not authenticated']);
        return;
    }
    
    $conn = getDBConnection();
    $userId = $_SESSION['user_id'];
    
    $query = "SELECT v.*, wh.watched_at, wh.progress FROM watch_history wh
              JOIN videos v ON wh.video_id = v.id
              WHERE wh.user_id = ?
              ORDER BY wh.watched_at DESC LIMIT 20";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $userId);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $videos = [];
    while ($row = $result->fetch_assoc()) {
        $videos[] = $row;
    }
    
    echo json_encode($videos);
    $conn->close();
}

function getFavorites() {
    if (!isset($_SESSION['user_id'])) {
        echo json_encode(['error' => 'Not authenticated']);
        return;
    }
    
    $conn = getDBConnection();
    $userId = $_SESSION['user_id'];
    
    $query = "SELECT v.*, f.created_at as favorited_at FROM favorites f
              JOIN videos v ON f.video_id = v.id
              WHERE f.user_id = ?
              ORDER BY f.created_at DESC";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $userId);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $videos = [];
    while ($row = $result->fetch_assoc()) {
        $videos[] = $row;
    }
    
    echo json_encode($videos);
    $conn->close();
}

function toggleFavorite() {
    if (!isset($_SESSION['user_id'])) {
        echo json_encode(['error' => 'Not authenticated']);
        return;
    }
    
    $conn = getDBConnection();
    $data = json_decode(file_get_contents('php://input'), true);
    $userId = $_SESSION['user_id'];
    $videoId = $data['video_id'] ?? 0;
    
    // Check if already favorited
    $checkQuery = "SELECT id FROM favorites WHERE user_id = ? AND video_id = ?";
    $stmt = $conn->prepare($checkQuery);
    $stmt->bind_param("ii", $userId, $videoId);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        // Remove favorite
        $deleteQuery = "DELETE FROM favorites WHERE user_id = ? AND video_id = ?";
        $stmt = $conn->prepare($deleteQuery);
        $stmt->bind_param("ii", $userId, $videoId);
        $stmt->execute();
        echo json_encode(['success' => true, 'favorited' => false]);
    } else {
        // Add favorite
        $insertQuery = "INSERT INTO favorites (user_id, video_id) VALUES (?, ?)";
        $stmt = $conn->prepare($insertQuery);
        $stmt->bind_param("ii", $userId, $videoId);
        $stmt->execute();
        echo json_encode(['success' => true, 'favorited' => true]);
    }
    
    $conn->close();
}

function checkFavorite($videoId) {
    if (!isset($_SESSION['user_id'])) {
        echo json_encode(['favorited' => false]);
        return;
    }
    
    $conn = getDBConnection();
    $userId = $_SESSION['user_id'];
    
    $query = "SELECT id FROM favorites WHERE user_id = ? AND video_id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("ii", $userId, $videoId);
    $stmt->execute();
    $result = $stmt->get_result();
    
    echo json_encode(['favorited' => $result->num_rows > 0]);
    $conn->close();
}
?>
